/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.common.util.HSCLogUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import org.snia.wbem.cim.CIMException;

public class HscProviderSocket {
    String m_hostname = null;
    int m_port = 0;
    Socket m_socket = null;
    DataOutputStream m_outstream = null;
    DataInputStream m_instream = null;
    String m_cecname = null;
    int m_sendRetrys = 0;
    private int MAX_SEND_RETRYS = 7;
    private boolean m_busy = false;
    private boolean m_hasCspConnection = true;
    private Thread m_thread = null;

    public HscProviderSocket(String string, int n, String string2) throws Exception {
        this.m_hostname = string;
        this.m_port = n;
        this.m_cecname = string2;
        this.initialize();
    }

    private void initialize() throws Exception {
        try {
            if (this.m_socket != null) {
                this.closeSocket();
            }
            this.m_sendRetrys = 0;
            System.out.println("HscProviderSocket: initializing the socket for " + this.m_cecname);
            this.m_socket = new Socket(this.m_hostname, this.m_port);
            this.m_outstream = new DataOutputStream(this.m_socket.getOutputStream());
            this.m_instream = new DataInputStream(this.m_socket.getInputStream());
            this.m_socket.setSoTimeout(30000);
            if (!this.isValid()) {
                throw new CIMException("1390");
            }
        }
        catch (IOException iOException) {
            HSCLogUtils.serverLog(iOException, HSCLogUtils._HSCClassLogInfo);
            iOException.printStackTrace();
            throw iOException;
        }
    }

    public boolean isValid() {
        try {
            int n = this.m_cecname.length();
            short s = (short)(~n);
            byte[] byArray = new byte[n + 3];
            byte[] byArray2 = new byte[n];
            byArray2 = this.m_cecname.getBytes();
            byArray[0] = -1;
            byArray[1] = (byte)(s & 0xFF);
            int n2 = 0;
            while (n2 < byArray2.length) {
                byArray[n2 + 2] = byArray2[n2];
                ++n2;
            }
            byArray[n + 2] = 0;
            this.m_outstream.write(byArray, 0, n + 3);
            byte[] byArray3 = new byte[2];
            this.m_instream.readFully(byArray3);
            int n3 = ~(byArray3[0] << 8 | byArray3[1] & 0xFF) + 1;
            if (n3 <= 1) {
                return false;
            }
            byte[] byArray4 = new byte[n3];
            this.m_instream.readFully(byArray4);
            String string = new String(byArray4);
            if (string.equals(this.m_cecname + "\u0000")) {
                return true;
            }
            System.out.println("CEC Name : " + string);
            System.out.println("HscProviderSocket: bug - m_cecname mismatch");
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public String getCecName() {
        return this.m_cecname;
    }

    public boolean lock() {
        return this.lock(0L);
    }

    public synchronized boolean lock(long l) {
        Thread thread = Thread.currentThread();
        if (this.m_thread != null) {
            if (thread.equals(this.m_thread)) {
                System.out.println("HscProviderSocket warning: you have the lock and try to get the lock again.");
                return false;
            }
            System.out.println("HscProviderSocket: lock owned by " + this.m_thread);
        }
        while (this.m_busy) {
            System.out.println("HscProviderSocket: Try to get ProviderSocket lock for " + this.m_cecname);
            try {
                if (l <= 0L) {
                    this.wait(10000L);
                    continue;
                }
                this.wait(l);
            }
            catch (Exception exception) {
                HSCLogUtils.serverLog(exception, HSCLogUtils._HSCClassLogInfo);
                System.out.println(exception);
            }
        }
        this.m_busy = true;
        this.m_thread = thread;
        System.out.println("HscProviderSocket: " + this.m_thread.getName() + " got ProviderSocket lock");
        return true;
    }

    public synchronized void releaseLock() {
        if (this.m_thread == null) {
            System.out.println("HscProviderSocket: lock not held");
            return;
        }
        Thread thread = Thread.currentThread();
        if (thread.equals(this.m_thread)) {
            this.m_thread = null;
            this.m_busy = false;
            this.notifyAll();
            System.out.println("HscProviderSocket: lock released by " + thread);
        } else {
            System.out.println("HscProviderSocket: lock was held by " + this.m_thread);
            System.out.println("HscProviderSocket: releaseLock failed");
        }
    }

    public synchronized void closeSocket() throws IOException {
        block2: {
            System.out.println("HscProviderSocket: closes ProviderSocket");
            if (this.m_socket == null) break block2;
            try {
                this.m_socket.close();
                this.m_socket = null;
            }
            catch (IOException iOException) {
                this.m_socket = null;
                iOException.printStackTrace();
            }
        }
    }

    public void setCspConnectionFlag(boolean bl) {
        this.m_hasCspConnection = bl;
        System.out.println("HscProviderSocket: hasCspConnection=" + this.m_hasCspConnection);
    }

    /*
     * Unable to fully structure code
     */
    public byte[] doCspCmd(byte[] var1_1, int var2_2) {
        block9: {
            var3_3 = null;
            if (this.m_thread == null) {
                System.out.println("HscProviderSocket: reject csp cmd because of not having the socket lock.");
                return var3_3;
            }
            var4_4 = Thread.currentThread();
            if (!var4_4.equals(this.m_thread)) {
                System.out.println("HscProviderSocket: reject csp cmd because of not having the socket lock");
                System.out.println("HscProviderSocket: lock owned by " + this.m_thread);
                return var3_3;
            }
            try {
                if (this.m_socket == null || this.m_sendRetrys >= this.MAX_SEND_RETRYS) {
                    this.initialize();
                }
                var3_3 = this.sendCmd(var1_1, var2_2);
                this.m_sendRetrys = 0;
                break block9;
            }
            catch (Exception var4_5) {
                var4_5.printStackTrace();
                System.out.println("Failed 1st sendCmd try...checking...");
                var5_6 = false;
                ** while (this.m_sendRetrys < this.MAX_SEND_RETRYS && !var5_6)
            }
lbl-1000:
            // 1 sources

            {
                if (!this.m_hasCspConnection) {
                    System.out.println("No connection to CSP... no more trying");
                    break;
                }
                try {
                    System.out.println("Try # " + this.m_sendRetrys + " to send command to socket...");
                    this.initialize();
                    var3_3 = this.sendCmd(var1_1, var2_2);
                    System.out.println("Try # " + this.m_sendRetrys + " succeeded.");
                    var5_6 = true;
                    this.m_sendRetrys = 0;
                }
                catch (Exception var6_7) {
                    System.out.println("Try # " + this.m_sendRetrys + " failed.");
                }
                ++this.m_sendRetrys;
                continue;
            }
lbl36:
            // 2 sources

            if (var5_6) break block9;
            var3_3 = null;
        }
        return var3_3;
    }

    private byte[] sendCmd(byte[] byArray, int n) throws Exception {
        int n2;
        this.m_socket.setSoTimeout(n);
        try {
            n2 = this.m_instream.available();
            this.m_instream.skipBytes(n2);
        }
        catch (IOException iOException) {
            System.out.println(" Excp in reading leftover bytes.");
        }
        this.m_outstream.write(byArray, 0, byArray.length);
        this.m_outstream.flush();
        System.out.println("send csp command: " + HscProviderSocket.byteArrayToHexString(byArray));
        n2 = this.m_instream.readUnsignedShort();
        System.out.println("length of csp response: " + n2);
        byte[] byArray2 = new byte[n2];
        this.m_instream.readFully(byArray2);
        System.out.println("csp response: " + HscProviderSocket.byteArrayToHexString(byArray2));
        return byArray2;
    }

    public static String byteArrayToHexString(byte[] byArray) {
        String string = "";
        int n = 0;
        while (n < byArray.length) {
            string = string + HscProviderSocket.byteToHexString(byArray[n]);
            ++n;
        }
        return string;
    }

    public static String byteToHexString(byte by) {
        String string = Long.toHexString(by);
        int n = string.length();
        if (n > 2) {
            string = string.substring(n - 2, n);
        } else {
            int n2 = 0;
            while (n2 < 2 - string.length()) {
                string = "0" + string;
                ++n2;
            }
        }
        return string;
    }

    public Thread getLockingThread() {
        if (this.m_busy) {
            return this.m_thread;
        }
        return null;
    }
}

